/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class ProjectHelperImpl
extends ProjectHelper {
    private Parser parser;
    private Project project;
    private File buildFile;
    private File buildFileParent;
    private Locator locator;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object source) throws BuildException {
        if (!(source instanceof File)) {
            throw new BuildException("Only File source supported by default plugin");
        }
        File buildFile = (File)source;
        FileInputStream inputStream = null;
        InputSource inputSource = null;
        this.project = project;
        this.buildFile = new File(buildFile.getAbsolutePath());
        this.buildFileParent = new File(this.buildFile.getParent());
        try {
            try {
                try {
                    this.parser = JAXPUtils.getParser();
                }
                catch (BuildException e) {
                    this.parser = new XMLReaderAdapter(JAXPUtils.getXMLReader());
                }
                String uri = "file:" + buildFile.getAbsolutePath().replace('\\', '/');
                int index = uri.indexOf(35);
                while (true) {
                    if (index == -1) {
                        inputStream = new FileInputStream(buildFile);
                        inputSource = new InputSource(inputStream);
                        inputSource.setSystemId(uri);
                        project.log("parsing buildfile " + buildFile + " with URI = " + uri, 3);
                        RootHandler hb = new RootHandler(this);
                        this.parser.setDocumentHandler(hb);
                        this.parser.setEntityResolver(hb);
                        this.parser.setErrorHandler(hb);
                        this.parser.setDTDHandler(hb);
                        this.parser.parse(inputSource);
                        break;
                    }
                    uri = uri.substring(0, index) + "%23" + uri.substring(index + 1);
                    index = uri.indexOf(35);
                }
            }
            catch (SAXParseException exc) {
                Location location = new Location(buildFile.toString(), exc.getLineNumber(), exc.getColumnNumber());
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), t, location);
                BuildException be = (BuildException)t;
                if (be.getLocation() != Location.UNKNOWN_LOCATION) throw be;
                be.setLocation(location);
                throw be;
            }
            catch (SAXException exc) {
                Exception t = exc.getException();
                if (!(t instanceof BuildException)) throw new BuildException(exc.getMessage(), t);
                throw (BuildException)t;
            }
            catch (FileNotFoundException exc) {
                throw new BuildException(exc);
            }
            catch (UnsupportedEncodingException exc) {
                throw new BuildException("Encoding of project file is invalid.", exc);
            }
            catch (IOException exc) {
                throw new BuildException("Error reading project file: " + exc.getMessage(), exc);
            }
            Object var12_16 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioe) {}
        inputStream.close();
        return;
    }

    private void configureId(Object target, AttributeList attr) {
        String id = attr.getValue("id");
        if (id != null) {
            this.project.addReference(id, target);
        }
    }

    static class DataTypeHandler
    extends AbstractHandler {
        private Target target;
        private Object element;
        private RuntimeConfigurable wrapper = null;

        public DataTypeHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler) {
            this(helperImpl, parentHandler, null);
        }

        public DataTypeHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler, Target target) {
            super(helperImpl, parentHandler);
            this.target = target;
        }

        public void init(String propType, AttributeList attrs) throws SAXParseException {
            try {
                this.element = this.helperImpl.project.createDataType(propType);
                if (this.element == null) {
                    throw new BuildException("Unknown data type " + propType);
                }
                if (this.target != null) {
                    this.wrapper = new RuntimeConfigurable(this.element, propType);
                    this.wrapper.setAttributes(attrs);
                    this.target.addDataType(this.wrapper);
                } else {
                    ProjectHelper.configure(this.element, attrs, this.helperImpl.project);
                    this.helperImpl.configureId(this.element, attrs);
                }
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), this.helperImpl.locator, exc);
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            try {
                ProjectHelper.addText(this.helperImpl.project, this.element, buf, start, count);
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), this.helperImpl.locator, exc);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            new NestedElementHandler(this.helperImpl, this, this.element, this.wrapper, this.target).init(name, attrs);
        }
    }

    static class NestedElementHandler
    extends AbstractHandler {
        private Object parent;
        private Object child;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable childWrapper = null;
        private Target target;

        public NestedElementHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler, Object parent, RuntimeConfigurable parentWrapper, Target target) {
            super(helperImpl, parentHandler);
            this.parent = parent instanceof TaskAdapter ? ((TaskAdapter)parent).getProxy() : parent;
            this.parentWrapper = parentWrapper;
            this.target = target;
        }

        public void init(String propType, AttributeList attrs) throws SAXParseException {
            Class<?> parentClass = this.parent.getClass();
            IntrospectionHelper ih = IntrospectionHelper.getHelper(parentClass);
            try {
                String elementName = propType.toLowerCase(Locale.US);
                if (this.parent instanceof UnknownElement) {
                    UnknownElement uc = new UnknownElement(elementName);
                    uc.setProject(this.helperImpl.project);
                    ((UnknownElement)this.parent).addChild(uc);
                    this.child = uc;
                } else {
                    this.child = ih.createElement(this.helperImpl.project, this.parent, elementName);
                }
                this.helperImpl.configureId(this.child, attrs);
                if (this.parentWrapper != null) {
                    this.childWrapper = new RuntimeConfigurable(this.child, propType);
                    this.childWrapper.setAttributes(attrs);
                    this.parentWrapper.addChild(this.childWrapper);
                } else {
                    ProjectHelper.configure(this.child, attrs, this.helperImpl.project);
                    ih.storeElement(this.helperImpl.project, this.parent, this.child, elementName);
                }
            }
            catch (BuildException exc) {
                throw new SAXParseException(exc.getMessage(), this.helperImpl.locator, exc);
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            if (this.parentWrapper == null) {
                try {
                    ProjectHelper.addText(this.helperImpl.project, this.child, buf, start, count);
                }
                catch (BuildException exc) {
                    throw new SAXParseException(exc.getMessage(), this.helperImpl.locator, exc);
                }
            } else {
                this.childWrapper.addText(buf, start, count);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            if (this.child instanceof TaskContainer) {
                new TaskHandler(this.helperImpl, this, (TaskContainer)this.child, this.childWrapper, this.target).init(name, attrs);
            } else {
                new NestedElementHandler(this.helperImpl, this, this.child, this.childWrapper, this.target).init(name, attrs);
            }
        }
    }

    static class TaskHandler
    extends AbstractHandler {
        private Target target;
        private TaskContainer container;
        private Task task;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable wrapper = null;

        public TaskHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler, TaskContainer container, RuntimeConfigurable parentWrapper, Target target) {
            super(helperImpl, parentHandler);
            this.container = container;
            this.parentWrapper = parentWrapper;
            this.target = target;
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            try {
                this.task = this.helperImpl.project.createTask(tag);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            if (this.task == null) {
                this.task = new UnknownElement(tag);
                this.task.setProject(this.helperImpl.project);
                this.task.setTaskName(tag);
            }
            this.task.setLocation(new Location(this.helperImpl.buildFile.toString(), this.helperImpl.locator.getLineNumber(), this.helperImpl.locator.getColumnNumber()));
            this.helperImpl.configureId(this.task, attrs);
            if (this.target != null) {
                this.task.setOwningTarget(this.target);
                this.container.addTask(this.task);
                this.task.init();
                this.wrapper = this.task.getRuntimeConfigurableWrapper();
                this.wrapper.setAttributes(attrs);
                if (this.parentWrapper != null) {
                    this.parentWrapper.addChild(this.wrapper);
                }
            } else {
                this.task.init();
                ProjectHelper.configure(this.task, attrs, this.helperImpl.project);
            }
        }

        protected void finished() {
            if (this.task != null && this.target == null) {
                this.task.execute();
            }
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            if (this.wrapper == null) {
                try {
                    ProjectHelper.addText(this.helperImpl.project, this.task, buf, start, count);
                }
                catch (BuildException exc) {
                    throw new SAXParseException(exc.getMessage(), this.helperImpl.locator, exc);
                }
            } else {
                this.wrapper.addText(buf, start, count);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            if (this.task instanceof TaskContainer) {
                new TaskHandler(this.helperImpl, this, (TaskContainer)((Object)this.task), this.wrapper, this.target).init(name, attrs);
            } else {
                new NestedElementHandler(this.helperImpl, this, this.task, this.wrapper, this.target).init(name, attrs);
            }
        }
    }

    static class TargetHandler
    extends AbstractHandler {
        private Target target;

        public TargetHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler) {
            super(helperImpl, parentHandler);
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            String name = null;
            String depends = "";
            String ifCond = null;
            String unlessCond = null;
            String id = null;
            String description = null;
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getName(i);
                String value = attrs.getValue(i);
                if (key.equals("name")) {
                    name = value;
                } else if (key.equals("depends")) {
                    depends = value;
                } else if (key.equals("if")) {
                    ifCond = value;
                } else if (key.equals("unless")) {
                    unlessCond = value;
                } else if (key.equals("id")) {
                    id = value;
                } else if (key.equals("description")) {
                    description = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + key + "\"", this.helperImpl.locator);
                }
                ++i;
            }
            if (name == null) {
                throw new SAXParseException("target element appears without a name attribute", this.helperImpl.locator);
            }
            this.target = new Target();
            this.target.setName(name);
            this.target.setIf(ifCond);
            this.target.setUnless(unlessCond);
            this.target.setDescription(description);
            this.helperImpl.project.addTarget(name, this.target);
            if (id != null && !id.equals("")) {
                this.helperImpl.project.addReference(id, this.target);
            }
            if (depends.length() > 0) {
                this.target.setDepends(depends);
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            if (this.helperImpl.project.getDataTypeDefinitions().get(name) != null) {
                new DataTypeHandler(this.helperImpl, this, this.target).init(name, attrs);
            } else {
                new TaskHandler(this.helperImpl, this, this.target, null, this.target).init(name, attrs);
            }
        }
    }

    static class ProjectHandler
    extends AbstractHandler {
        public ProjectHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler) {
            super(helperImpl, parentHandler);
        }

        public void init(String tag, AttributeList attrs) throws SAXParseException {
            String def = null;
            String name = null;
            String id = null;
            String baseDir = null;
            int i = 0;
            while (i < attrs.getLength()) {
                String key = attrs.getName(i);
                String value = attrs.getValue(i);
                if (key.equals("default")) {
                    def = value;
                } else if (key.equals("name")) {
                    name = value;
                } else if (key.equals("id")) {
                    id = value;
                } else if (key.equals("basedir")) {
                    baseDir = value;
                } else {
                    throw new SAXParseException("Unexpected attribute \"" + attrs.getName(i) + "\"", this.helperImpl.locator);
                }
                ++i;
            }
            if (def == null) {
                this.helperImpl.project.setDefaultTarget("main");
            } else {
                this.helperImpl.project.setDefaultTarget(def);
            }
            if (name != null) {
                this.helperImpl.project.setName(name);
                this.helperImpl.project.addReference(name, this.helperImpl.project);
            }
            if (id != null) {
                this.helperImpl.project.addReference(id, this.helperImpl.project);
            }
            if (this.helperImpl.project.getProperty("basedir") != null) {
                this.helperImpl.project.setBasedir(this.helperImpl.project.getProperty("basedir"));
            } else if (baseDir == null) {
                this.helperImpl.project.setBasedir(this.helperImpl.buildFileParent.getAbsolutePath());
            } else if (new File(baseDir).isAbsolute()) {
                this.helperImpl.project.setBasedir(baseDir);
            } else {
                this.helperImpl.project.setBaseDir(this.helperImpl.project.resolveFile(baseDir, this.helperImpl.buildFileParent));
            }
        }

        public void startElement(String name, AttributeList attrs) throws SAXParseException {
            if (name.equals("taskdef")) {
                this.handleTaskdef(name, attrs);
            } else if (name.equals("typedef")) {
                this.handleTypedef(name, attrs);
            } else if (name.equals("property")) {
                this.handleProperty(name, attrs);
            } else if (name.equals("target")) {
                this.handleTarget(name, attrs);
            } else if (this.helperImpl.project.getDataTypeDefinitions().get(name) != null) {
                this.handleDataType(name, attrs);
            } else {
                throw new SAXParseException("Unexpected element \"" + name + "\"", this.helperImpl.locator);
            }
        }

        private void handleTaskdef(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this.helperImpl, this, null, null, null).init(name, attrs);
        }

        private void handleTypedef(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this.helperImpl, this, null, null, null).init(name, attrs);
        }

        private void handleProperty(String name, AttributeList attrs) throws SAXParseException {
            new TaskHandler(this.helperImpl, this, null, null, null).init(name, attrs);
        }

        private void handleTarget(String tag, AttributeList attrs) throws SAXParseException {
            new TargetHandler(this.helperImpl, this).init(tag, attrs);
        }

        private void handleDataType(String name, AttributeList attrs) throws SAXParseException {
            new DataTypeHandler(this.helperImpl, this).init(name, attrs);
        }
    }

    static class RootHandler
    extends HandlerBase {
        ProjectHelperImpl helperImpl;

        public RootHandler(ProjectHelperImpl helperImpl) {
            this.helperImpl = helperImpl;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            this.helperImpl.project.log("resolving systemId: " + systemId, 3);
            if (systemId.startsWith("file:")) {
                String path = systemId.substring(5);
                int index = path.indexOf("file:");
                while (index != -1) {
                    path = path.substring(0, index) + path.substring(index + 5);
                    index = path.indexOf("file:");
                }
                String entitySystemId = path;
                index = path.indexOf("%23");
                while (index != -1) {
                    path = path.substring(0, index) + "#" + path.substring(index + 3);
                    index = path.indexOf("%23");
                }
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = new File(this.helperImpl.buildFileParent, path);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId("file:" + entitySystemId);
                    return inputSource;
                }
                catch (FileNotFoundException fne) {
                    this.helperImpl.project.log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            if (!tag.equals("project")) {
                throw new SAXParseException("Config file is not of expected XML type", this.helperImpl.locator);
            }
            new ProjectHandler(this.helperImpl, this).init(tag, attrs);
        }

        public void setDocumentLocator(Locator locator) {
            this.helperImpl.locator = locator;
        }
    }

    static class AbstractHandler
    extends HandlerBase {
        protected DocumentHandler parentHandler;
        ProjectHelperImpl helperImpl;

        public AbstractHandler(ProjectHelperImpl helperImpl, DocumentHandler parentHandler) {
            this.parentHandler = parentHandler;
            this.helperImpl = helperImpl;
            helperImpl.parser.setDocumentHandler(this);
        }

        public void startElement(String tag, AttributeList attrs) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + tag + "\"", this.helperImpl.locator);
        }

        public void characters(char[] buf, int start, int count) throws SAXParseException {
            String s = new String(buf, start, count).trim();
            if (s.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + s + "\"", this.helperImpl.locator);
            }
        }

        protected void finished() {
        }

        public void endElement(String name) throws SAXException {
            this.finished();
            this.helperImpl.parser.setDocumentHandler(this.parentHandler);
        }
    }
}

