/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.StringUtils;

public class Parallel
extends Task
implements TaskContainer {
    private Vector nestedTasks = new Vector();

    public void addTask(Task nestedTask) throws BuildException {
        this.nestedTasks.addElement(nestedTask);
    }

    public void execute() throws BuildException {
        TaskThread[] threads = new TaskThread[this.nestedTasks.size()];
        int threadNumber = 0;
        Enumeration e = this.nestedTasks.elements();
        while (e.hasMoreElements()) {
            Task nestedTask = (Task)e.nextElement();
            threads[threadNumber] = new TaskThread(threadNumber, nestedTask);
            ++threadNumber;
        }
        int i = 0;
        while (i < threads.length) {
            threads[i].start();
            ++i;
        }
        int i2 = 0;
        while (i2 < threads.length) {
            try {
                threads[i2].join();
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++i2;
        }
        StringBuffer exceptionMessage = new StringBuffer();
        int numExceptions = 0;
        Throwable firstException = null;
        Location firstLocation = Location.UNKNOWN_LOCATION;
        int i3 = 0;
        while (i3 < threads.length) {
            Throwable t = threads[i3].getException();
            if (t != null) {
                ++numExceptions;
                if (firstException == null) {
                    firstException = t;
                }
                if (t instanceof BuildException && firstLocation == Location.UNKNOWN_LOCATION) {
                    firstLocation = ((BuildException)t).getLocation();
                }
                exceptionMessage.append(StringUtils.LINE_SEP);
                exceptionMessage.append(t.getMessage());
            }
            ++i3;
        }
        if (numExceptions == 1) {
            if (firstException instanceof BuildException) {
                throw (BuildException)firstException;
            }
            throw new BuildException(firstException);
        }
        if (numExceptions > 1) {
            throw new BuildException(exceptionMessage.toString(), firstLocation);
        }
    }

    class TaskThread
    extends Thread {
        private Throwable exception;
        private Task task;
        private int taskNumber;

        TaskThread(int taskNumber, Task task) {
            this.task = task;
            this.taskNumber = taskNumber;
        }

        public void run() {
            try {
                this.task.perform();
            }
            catch (Throwable t) {
                this.exception = t;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

